/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import libsidplay.config.ISidPlay2SystemProperties;
import libsidplay.sidtune.MD5Method;
import libsidplay.sidtune.PSidHeader;
import libsidplay.sidtune.Prg;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.assembler.KickAssembler;
import libsidutils.assembler.KickAssemblerResult;
import libsidutils.reloc65.Reloc65;

class PSid
extends Prg {
    private static final String PSID_DRIVER_ASM = "/libsidplay/sidtune/psiddriver.asm";
    private static final String PSID_DRIVER_BIN = "/libsidplay/sidtune/psiddriver.bin";
    private static final int PSID_MUS = 1;
    private static final int PSID_SPECIFIC = 2;
    private static final int PSID_BASIC = 2;
    private static final int SIDTUNE_MAX_SONGS = 256;
    private PSidHeader header;
    private SidTune.Speed[] songSpeed = new SidTune.Speed[256];
    private KickAssemblerResult preparedDriver;

    PSid() {
    }

    @Override
    public Integer placeProgramInMemory(byte[] mem) {
        super.placeProgramInMemory(mem);
        if (this.info.compatibility == SidTune.Compatibility.RSID_BASIC) {
            mem[780] = (byte)(this.info.currentSong - 1);
            return null;
        }
        if (USE_KICKASSEMBLER) {
            return this.assembleAndInstallDriver(mem);
        }
        return this.relocateAndInstallDriver(mem);
    }

    @Override
    public Integer placeProgramInMemory(byte[] mem, byte[] driver) {
        super.placeProgramInMemory(mem);
        if (this.info.compatibility == SidTune.Compatibility.RSID_BASIC) {
            mem[780] = (byte)(this.info.currentSong - 1);
            return null;
        }
        return this.relocateAndInstallDriver(mem, driver);
    }

    @Override
    public void prepare() {
        if (USE_KICKASSEMBLER) {
            HashMap<String, String> globals = new HashMap<String, String>();
            globals.put("pc", String.valueOf(this.info.determinedDriverAddr));
            globals.put("songNum", String.valueOf(this.info.currentSong));
            globals.put("songs", String.valueOf(this.info.songs));
            globals.put("songSpeed", String.valueOf(this.getSongSpeed(this.info.currentSong) == SidTune.Speed.CIA_1A ? 1 : 0));
            globals.put("speed", String.valueOf(this.getSongSpeedWord()));
            globals.put("loadAddr", String.valueOf(this.info.loadAddr));
            globals.put("initAddr", String.valueOf(this.info.initAddr));
            globals.put("playAddr", String.valueOf(this.info.playAddr));
            globals.put("powerOnDelay", String.valueOf((int)(256L + (System.currentTimeMillis() & 0x1FFL))));
            globals.put("initIOMap", String.valueOf(this.info.iomap(this.info.initAddr)));
            globals.put("playIOMap", String.valueOf(this.info.iomap(this.info.playAddr)));
            globals.put("videoMode", String.valueOf(this.info.clockSpeed == SidTune.Clock.PAL ? 1 : 0));
            if (this.info.compatibility == SidTune.Compatibility.RSIDv2 || this.info.compatibility == SidTune.Compatibility.RSIDv3 || this.info.compatibility == SidTune.Compatibility.RSIDv4E) {
                globals.put("flags", String.valueOf(1));
            } else {
                globals.put("flags", String.valueOf(4));
            }
            InputStream asm = PSid.class.getResourceAsStream(PSID_DRIVER_ASM);
            this.preparedDriver = KickAssembler.assemble((String)PSID_DRIVER_ASM, (InputStream)asm, globals);
        }
    }

    private int assembleAndInstallDriver(byte[] mem) {
        if (this.preparedDriver == null) {
            this.prepare();
        }
        this.info.determinedDriverLength = this.preparedDriver.getData().length - 2;
        System.arraycopy(this.preparedDriver.getData(), 2, mem, this.info.determinedDriverAddr, this.info.determinedDriverLength);
        if (this.info.determinedDriverLength + 255 >> 8 != 1) {
            throw new RuntimeException("Driver must not be greater than one block! /libsidplay/sidtune/psiddriver.asm");
        }
        Integer start = (Integer)this.preparedDriver.getResolvedSymbols().get("start");
        if (start == null) {
            throw new RuntimeException("Label start not found in /libsidplay/sidtune/psiddriver.asm");
        }
        return start;
    }

    private int relocateAndInstallDriver(byte[] ram) {
        int n;
        DataInputStream is = new DataInputStream(PSid.class.getResourceAsStream(PSID_DRIVER_BIN));
        try {
            URL url = PSid.class.getResource(PSID_DRIVER_BIN);
            byte[] PSID_DRIVER = new byte[url.openConnection().getContentLength()];
            is.readFully(PSID_DRIVER);
            n = this.relocateAndInstallDriver(ram, PSID_DRIVER);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Load failed for resource: /libsidplay/sidtune/psiddriver.bin");
            }
        }
        is.close();
        return n;
    }

    private int relocateAndInstallDriver(byte[] ram, byte[] PSID_DRIVER) {
        ByteBuffer relocatedBuffer = new Reloc65().reloc65(PSID_DRIVER, this.info.determinedDriverAddr - 10);
        if (relocatedBuffer == null) {
            throw new RuntimeException("Failed to relocate driver.");
        }
        this.info.determinedDriverLength = relocatedBuffer.limit() - 10;
        byte[] reloc_driver = relocatedBuffer.array();
        int reloc_driverPos = relocatedBuffer.position();
        if (this.info.playAddr != 0 || this.info.loadAddr != 512) {
            ram[788] = reloc_driver[reloc_driverPos + 2];
            ram[789] = reloc_driver[reloc_driverPos + 2 + 1];
            if (this.info.compatibility != SidTune.Compatibility.RSIDv2 && this.info.compatibility != SidTune.Compatibility.RSIDv3 && this.info.compatibility != SidTune.Compatibility.RSIDv4E) {
                ram[790] = reloc_driver[reloc_driverPos + 2 + 2];
                ram[791] = reloc_driver[reloc_driverPos + 2 + 3];
                ram[792] = reloc_driver[reloc_driverPos + 2 + 4];
                ram[793] = reloc_driver[reloc_driverPos + 2 + 5];
            }
        }
        int pos = this.info.determinedDriverAddr;
        System.arraycopy(reloc_driver, reloc_driverPos + 10, ram, pos, this.info.determinedDriverLength);
        ram[pos++] = (byte)(this.info.currentSong - 1);
        ram[pos++] = (byte)(this.songSpeed[this.info.currentSong - 1] != SidTune.Speed.VBI ? 1 : 0);
        ram[pos++] = (byte)(this.info.initAddr & 0xFF);
        ram[pos++] = (byte)(this.info.initAddr >> 8);
        ram[pos++] = (byte)(this.info.playAddr & 0xFF);
        ram[pos++] = (byte)(this.info.playAddr >> 8);
        int powerOnDelay = (int)(256L + (System.currentTimeMillis() & 0x1FFL));
        ram[pos++] = (byte)(powerOnDelay & 0xFF);
        ram[pos++] = (byte)(powerOnDelay >> 8);
        ram[pos++] = (byte)this.info.iomap(this.info.initAddr);
        ram[pos++] = (byte)this.info.iomap(this.info.playAddr);
        ram[pos++] = ram[678];
        switch (this.info.clockSpeed) {
            case PAL: {
                ram[pos++] = 1;
                break;
            }
            case NTSC: {
                ram[pos++] = 0;
                break;
            }
            default: {
                ram[pos++] = ram[678];
            }
        }
        ram[pos++] = this.info.compatibility == SidTune.Compatibility.RSIDv2 || this.info.compatibility == SidTune.Compatibility.RSIDv3 || this.info.compatibility == SidTune.Compatibility.RSIDv4E ? 0 : 4;
        return reloc_driver[reloc_driverPos + 0] & 0xFF | (reloc_driver[reloc_driverPos + 1] & 0xFF) << 8;
    }

    private void resolveAddrs() throws SidTuneError {
        if (this.info.playAddr == 65535) {
            this.info.playAddr = 0;
        }
        if (this.info.loadAddr == 0) {
            if (this.info.c64dataLen < 2) {
                throw new SidTuneError("PSID: Song is truncated");
            }
            this.info.loadAddr = (this.program[this.programOffset] & 0xFF) + ((this.program[this.programOffset + 1] & 0xFF) << 8);
            this.programOffset += 2;
            this.info.c64dataLen -= 2;
        }
        if (this.info.compatibility == SidTune.Compatibility.RSID_BASIC) {
            if (this.info.initAddr != 0) {
                throw new SidTuneError("PSID: Init address given for a RSID tune with BASIC flag");
            }
        } else if (this.info.initAddr == 0) {
            this.info.initAddr = this.info.loadAddr;
        }
    }

    protected void findPlaceForDriver() throws SidTuneError {
        short startlp = (short)(this.info.loadAddr >> 8);
        short endlp = (short)(this.info.loadAddr + this.info.c64dataLen - 1 >> 8);
        if (this.info.relocStartPage == 255) {
            this.info.relocPages = 0;
        } else if (this.info.relocPages == 0) {
            this.info.relocStartPage = 0;
        } else {
            short startp = this.info.relocStartPage;
            short endp = (short)(startp + this.info.relocPages - 1 & 0xFF);
            if (endp < startp) {
                throw new SidTuneError(String.format("PSID: Relocation info is invalid: end before start: end=%02x, start=%02x", endp, startp));
            }
            if (startp <= startlp && endp >= startlp || startp <= endlp && endp >= endlp) {
                throw new SidTuneError(String.format("PSID: Relocation info is invalid: relocation in middle of song tune itself: songstart=%02x, songend=%02x, relocstart=%02x, relocend=%02x", startlp, endlp, startp, endp));
            }
            if (startp < 4 || 160 <= startp && startp <= 191 || startp >= 208 || 160 <= endp && endp <= 191 || endp >= 208) {
                throw new SidTuneError(String.format("PSID: Relocation info is invalid: beyond acceptable bounds (kernal, basic, io, < 4th page): %02x-%02x", startp, endp));
            }
        }
        this.info.determinedDriverAddr = this.info.relocStartPage << 8;
        if (this.info.determinedDriverAddr == 0) {
            boolean driverLen = true;
            block0: for (int i = 4; i < 208; ++i) {
                for (int j = 0; j < 1; ++j) {
                    if (i + j >= startlp && i + j <= endlp || i + j >= 160 && i + j <= 191) continue block0;
                }
                this.info.determinedDriverAddr = i << 8;
                break;
            }
        }
        if (this.info.determinedDriverAddr == 0) {
            throw new SidTuneError("PSID: Can't relocate tune: no pages left to store driver.");
        }
    }

    protected static SidTune load(String name, byte[] dataBuf) throws SidTuneError {
        int speed;
        PSid psid;
        block39: {
            block38: {
                if (dataBuf.length < 124) {
                    throw new SidTuneError(String.format("PSID: Header too short: %d, expected (%d)", dataBuf.length, 124));
                }
                psid = new PSid();
                psid.header = new PSidHeader(dataBuf);
                if ((psid.header.flags & 1) != 0) {
                    throw new SidTuneError("PSID: MUS-specific PSIDs are not supported by this player");
                }
                psid.program = dataBuf;
                psid.programOffset = psid.header.data;
                psid.info.c64dataLen = dataBuf.length - psid.programOffset;
                psid.info.loadAddr = psid.header.load & 0xFFFF;
                psid.info.initAddr = psid.header.init & 0xFFFF;
                psid.info.playAddr = psid.header.play & 0xFFFF;
                psid.info.songs = psid.header.songs & 0xFFFF;
                if (psid.info.songs == 0) {
                    ++psid.info.songs;
                }
                if (psid.info.songs > 256) {
                    psid.info.songs = 256;
                }
                psid.info.startSong = psid.header.start & 0xFFFF;
                if (psid.info.startSong > psid.info.songs) {
                    psid.info.startSong = 1;
                } else if (psid.info.startSong == 0) {
                    ++psid.info.startSong;
                }
                speed = psid.header.speed;
                if (!Arrays.equals(psid.header.id, "PSID".getBytes(PSidHeader.ISO_8859_1))) break block38;
                switch (psid.header.version) {
                    case 1: {
                        psid.info.compatibility = SidTune.Compatibility.PSIDv1;
                        break block39;
                    }
                    case 2: {
                        psid.info.compatibility = SidTune.Compatibility.PSIDv2;
                        if ((psid.header.flags & 2) != 0) {
                            throw new SidTuneError("PSID: PSID-specific files are not supported by this player");
                        }
                        break block39;
                    }
                    case 3: {
                        psid.info.compatibility = SidTune.Compatibility.PSIDv3;
                        break block39;
                    }
                    case 4: {
                        psid.info.compatibility = SidTune.Compatibility.PSIDv4;
                        break block39;
                    }
                    case 78: {
                        psid.info.compatibility = SidTune.Compatibility.PSIDv4E;
                        break block39;
                    }
                    default: {
                        throw new SidTuneError("PSID: PSID version must be 1, 2, 3, 4 or 0x4E, now: " + psid.header.version);
                    }
                }
            }
            if (Arrays.equals(psid.header.id, "RSID".getBytes(PSidHeader.ISO_8859_1))) {
                if ((psid.header.flags & 2) != 0) {
                    psid.info.compatibility = SidTune.Compatibility.RSID_BASIC;
                } else {
                    switch (psid.header.version) {
                        case 2: {
                            psid.info.compatibility = SidTune.Compatibility.RSIDv2;
                            break;
                        }
                        case 3: {
                            psid.info.compatibility = SidTune.Compatibility.RSIDv3;
                            break;
                        }
                        case 78: {
                            psid.info.compatibility = SidTune.Compatibility.RSIDv4E;
                            break;
                        }
                        default: {
                            throw new SidTuneError("PSID: RSID version must be 2 or 3 or 0x4E, now: " + psid.header.version);
                        }
                    }
                }
                if (psid.info.loadAddr != 0 || psid.info.playAddr != 0 || speed != 0) {
                    throw new SidTuneError("PSID: RSID tune specified load, play or speed information.");
                }
                speed = -1;
            } else {
                throw new SidTuneError("PSID: Bad PSID header, expected (PSID or RSID)");
            }
        }
        int clock = 0;
        int model1 = 0;
        int model2 = 0;
        int model3 = 0;
        if (psid.header.version == 78) {
            int channel1;
            clock = psid.header.flags >> 2 & 3;
            model1 = psid.header.flags >> 4 & 3;
            psid.info.channel[0] = channel1 = psid.header.flags >> 6 & 1;
            if (psid.header.furtherFlags.length + 1 > ISidPlay2SystemProperties.MAX_SIDS) {
                throw new SidTuneError(String.format("PSIDv4E: Too many SIDs: %d, MAX_SIDS (%d)", psid.header.furtherFlags.length + 1, ISidPlay2SystemProperties.MAX_SIDS));
            }
            for (int i = 0; i < psid.header.furtherFlags.length; ++i) {
                int modelN = psid.header.furtherFlags[i] >> 4 & 3;
                int channelN = psid.header.furtherFlags[i] >> 6 & 1;
                int sidlocN = 0xD000 | psid.header.furtherFlags[i] >> 8 << 4;
                if ((sidlocN >= 54304 && sidlocN < 55296 || sidlocN >= 56832) && (sidlocN & 0x10) == 0) {
                    psid.info.sidChipBase[1 + i] = sidlocN;
                    if (modelN == 0) {
                        modelN = model1;
                    }
                    psid.info.channel[1 + i] = channelN;
                }
                psid.info.sidModel[1 + i] = SidTune.Model.values()[modelN];
            }
        } else {
            if (psid.header.version >= 2) {
                clock = psid.header.flags >> 2 & 3;
                model1 = psid.header.flags >> 4 & 3;
                psid.info.relocStartPage = (short)(psid.header.relocStartPage & 0xFF);
                psid.info.relocPages = (short)(psid.header.relocPages & 0xFF);
            }
            if (psid.header.version >= 3) {
                model2 = psid.header.flags >> 6 & 3;
                int sid2loc = 0xD000 | (psid.header.sidChip2MiddleNybbles & 0xFF) << 4;
                if ((sid2loc >= 54304 && sid2loc < 55296 || sid2loc >= 56832) && (sid2loc & 0x10) == 0) {
                    psid.info.sidChipBase[1] = sid2loc;
                    if (model2 == 0) {
                        model2 = model1;
                    }
                }
            }
            if (psid.header.version >= 4) {
                model3 = psid.header.flags >> 8 & 3;
                int sid3loc = 0xD000 | (psid.header.sidChip3MiddleNybbles & 0xFF) << 4;
                if ((sid3loc >= 54304 && sid3loc < 55296 || sid3loc >= 56832) && (sid3loc & 0x10) == 0) {
                    psid.info.sidChipBase[2] = sid3loc;
                    if (model3 == 0) {
                        model3 = model1;
                    }
                }
            }
            psid.info.sidModel[1] = SidTune.Model.values()[model2];
            psid.info.sidModel[2] = SidTune.Model.values()[model3];
        }
        psid.info.clockSpeed = SidTune.Clock.values()[clock];
        psid.info.sidModel[0] = SidTune.Model.values()[model1];
        psid.convertOldStyleSpeedToTables(speed);
        psid.info.infoString.add(PSidHeader.getString(psid.header.name));
        psid.info.infoString.add(PSidHeader.getString(psid.header.author));
        psid.info.infoString.add(PSidHeader.getString(psid.header.released));
        psid.resolveAddrs();
        psid.findPlaceForDriver();
        return psid;
    }

    @Override
    public byte[] getPSidHeader() {
        return this.header.getArray();
    }

    private void convertOldStyleSpeedToTables(long speed) {
        for (int s = 0; s < 256; ++s) {
            int i = s > 31 ? 31 : s;
            this.songSpeed[s] = (speed & (long)(1 << i)) != 0L ? SidTune.Speed.CIA_1A : SidTune.Speed.VBI;
        }
    }

    @Override
    public int getSongSpeedWord() {
        int speed = 0;
        for (int i = 0; i < 32; ++i) {
            if (this.songSpeed[i] == SidTune.Speed.VBI) continue;
            speed |= 1 << i;
        }
        return speed;
    }

    @Override
    public SidTune.Speed getSongSpeed(int selected) {
        return this.songSpeed[selected - 1];
    }

    @Override
    public void save(String name) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(!name.endsWith(".sid") ? name + ".sid" : name);){
            int sidCount;
            for (sidCount = 0; sidCount < ISidPlay2SystemProperties.MAX_SIDS && this.info.sidChipBase[sidCount] != 0; ++sidCount) {
            }
            PSidHeader header = new PSidHeader();
            header.id = "PSID".getBytes(PSidHeader.ISO_8859_1);
            header.version = sidCount > 3 ? (short)78 : (this.info.sidChipBase[2] != 0 ? (short)4 : (this.info.sidChipBase[1] != 0 ? (short)3 : (short)2));
            header.data = (short)(124 + (sidCount > 3 ? sidCount - 1 << 1 : 0));
            header.songs = (short)this.info.songs;
            header.start = (short)this.info.startSong;
            header.speed = this.getSongSpeedWord();
            header.init = (short)this.info.initAddr;
            header.relocStartPage = (byte)this.info.relocStartPage;
            header.relocPages = (byte)this.info.relocPages;
            if (sidCount > 3) {
                header.furtherFlags = new short[sidCount - 1];
                int i = 0;
                while (i < header.furtherFlags.length) {
                    int chipMiddleNibblesN = (this.info.sidChipBase[1 + i] & 0x2FFF) >> 4;
                    int modelN = this.info.sidModel[1 + i] == this.info.sidModel[0] ? 0 : this.info.sidModel[1 + i].ordinal();
                    int channelN = this.info.channel[1 + i] & 1;
                    int n = i;
                    header.furtherFlags[n] = (short)(header.furtherFlags[n] | chipMiddleNibblesN << 8);
                    int n2 = i;
                    header.furtherFlags[n2] = (short)(header.furtherFlags[n2] | channelN << 6);
                    int n3 = i++;
                    header.furtherFlags[n3] = (short)(header.furtherFlags[n3] | modelN << 4);
                }
            } else {
                if (this.info.sidChipBase[1] != 0) {
                    header.sidChip2MiddleNybbles = (byte)((this.info.sidChipBase[1] & 0x2FFF) >> 4);
                }
                if (this.info.sidChipBase[2] != 0) {
                    header.sidChip3MiddleNybbles = (byte)((this.info.sidChipBase[2] & 0x2FFF) >> 4);
                }
            }
            header.flags = 0;
            switch (this.info.compatibility) {
                case RSID_BASIC: {
                    header.flags = (short)(header.flags | 2);
                }
                case RSIDv2: 
                case RSIDv3: 
                case RSIDv4E: {
                    header.id = "RSID".getBytes(PSidHeader.ISO_8859_1);
                    header.speed = 0;
                    break;
                }
                case PSIDv1: {
                    throw new IOException("PSID-specific files are not supported by this player");
                }
                default: {
                    header.play = (short)this.info.playAddr;
                }
            }
            if (this.info.infoString.size() == 3) {
                Iterator<String> descriptionIt = this.info.infoString.iterator();
                String title = descriptionIt.next();
                String author = descriptionIt.next();
                String released = descriptionIt.next();
                if (header.version == 2 && title.length() == 32 || author.length() == 32 || released.length() == 32) {
                    header.version = (short)3;
                }
                byte[] titleBytes = title.getBytes(PSidHeader.ISO_8859_1);
                for (int i = 0; i < title.length(); ++i) {
                    header.name[i] = titleBytes[i];
                }
                byte[] authorBytes = author.getBytes(PSidHeader.ISO_8859_1);
                for (int i = 0; i < author.length(); ++i) {
                    header.author[i] = authorBytes[i];
                }
                byte[] releasedBytes = released.getBytes(PSidHeader.ISO_8859_1);
                for (int i = 0; i < released.length(); ++i) {
                    header.released[i] = releasedBytes[i];
                }
            }
            header.flags = (short)(header.flags | this.info.clockSpeed.ordinal() << 2);
            header.flags = (short)(header.flags | this.info.sidModel[0].ordinal() << 4);
            if (sidCount > 3) {
                header.flags = (short)(header.flags | (this.info.channel[0] > 0 ? 1 : 0) << 6);
            } else {
                header.flags = (short)(header.flags | this.info.sidModel[1].ordinal() << 6);
                header.flags = (short)(header.flags | this.info.sidModel[2].ordinal() << 8);
            }
            fos.write(header.getArray());
            byte[] saveAddr = new byte[]{(byte)(this.info.loadAddr & 0xFF), (byte)(this.info.loadAddr >> 8)};
            fos.write(saveAddr);
            fos.write(this.program, this.programOffset, this.info.c64dataLen);
        }
    }

    @Override
    public String getMD5Digest(MD5Method md5Method) {
        if (md5Method == MD5Method.MD5_PSID_HEADER) {
            byte[] myMD5 = new byte[this.info.c64dataLen + 6 + this.info.songs + (this.info.clockSpeed == SidTune.Clock.NTSC ? 1 : 0)];
            System.arraycopy(this.program, this.programOffset, myMD5, 0, this.info.c64dataLen);
            int i = this.info.c64dataLen;
            myMD5[i++] = (byte)(this.info.initAddr & 0xFF);
            myMD5[i++] = (byte)(this.info.initAddr >> 8);
            myMD5[i++] = (byte)(this.info.playAddr & 0xFF);
            myMD5[i++] = (byte)(this.info.playAddr >> 8);
            myMD5[i++] = (byte)(this.info.songs & 0xFF);
            myMD5[i++] = (byte)(this.info.songs >> 8);
            for (int s = 1; s <= this.info.songs; ++s) {
                myMD5[i++] = (byte)this.getSongSpeed(s).speedValue();
            }
            if (this.info.clockSpeed == SidTune.Clock.NTSC) {
                myMD5[i++] = (byte)this.info.clockSpeed.ordinal();
            }
            StringBuilder md5 = new StringBuilder();
            try {
                byte[] encryptMsg;
                for (byte anEncryptMsg : encryptMsg = MessageDigest.getInstance("MD5").digest(this.program)) {
                    md5.append(Character.forDigit(anEncryptMsg >> 4 & 0xF, 16));
                    md5.append(Character.forDigit(anEncryptMsg & 0xF, 16));
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            return md5.toString();
        }
        return super.getMD5Digest(md5Method);
    }

    @Override
    public long getInitDelay() {
        return this.info.compatibility == SidTune.Compatibility.RSID_BASIC || this.info.compatibility == SidTune.Compatibility.RSIDv2 || this.info.compatibility == SidTune.Compatibility.RSIDv3 || this.info.compatibility == SidTune.Compatibility.RSIDv4E ? 2500000L : 2141000L;
    }
}

