/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.common;

import libsidplay.common.ChipModel;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2SystemProperties;
import libsidplay.sidtune.SidTune;

public enum ChipModel {
    AUTO,
    MOS6581,
    MOS8580;


    public static ChipModel getChipModel(IEmulationSection emulation, SidTune tune, int sidNum) {
        ChipModel defaultSidModel;
        SidTune.Model tuneSidModel;
        ChipModel forcedChipModel = emulation.getForcedSidModel(sidNum);
        ChipModel overrideSidModel = emulation.getOverrideSection().getSidModel()[sidNum];
        switch (sidNum) {
            case 0: {
                tuneSidModel = tune != SidTune.RESET ? tune.getInfo().getSIDModel(0) : SidTune.Model.UNKNOWN;
                defaultSidModel = emulation.getDefaultSidModel();
                break;
            }
            default: {
                if (sidNum < ISidPlay2SystemProperties.MAX_SIDS) {
                    tuneSidModel = tune != SidTune.RESET ? tune.getInfo().getSIDModel(sidNum) : SidTune.Model.UNKNOWN;
                    defaultSidModel = ChipModel.getChipModel(emulation, tune, 0);
                    break;
                }
                throw new RuntimeException("Maximum supported SIDS exceeded!");
            }
        }
        if (forcedChipModel != AUTO) {
            return forcedChipModel;
        }
        if (overrideSidModel != null) {
            return overrideSidModel;
        }
        switch (1.$SwitchMap$libsidplay$sidtune$SidTune$Model[tuneSidModel.ordinal()]) {
            case 1: 
            case 2: {
                return tuneSidModel.asChipModel();
            }
        }
        return defaultSidModel;
    }
}

