/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.common;

import libsidplay.common.CPUClock;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;

public enum CPUClock {
    AUTO,
    PAL(985248.4, 63, 312),
    NTSC(1022727.14, 65, 263);

    private final double cpuFrequency;
    private final double screenRefresh;
    private final int cyclesPerFrame;

    private CPUClock() {
        this.cpuFrequency = 0.0;
        this.cyclesPerFrame = 0;
        this.screenRefresh = 0.0;
    }

    private CPUClock(double cpuFrequency, int cyclesPerLine, int maxRasters) {
        this.cpuFrequency = cpuFrequency;
        this.cyclesPerFrame = cyclesPerLine * maxRasters;
        this.screenRefresh = cpuFrequency / (double)this.cyclesPerFrame;
    }

    public double getCpuFrequency() {
        return this.cpuFrequency;
    }

    public int getCyclesPerFrame() {
        return this.cyclesPerFrame;
    }

    public double getScreenRefresh() {
        return this.screenRefresh;
    }

    public static CPUClock getCPUClock(IEmulationSection emulation, SidTune tune) {
        CPUClock forcedCPUClock = emulation.getUserClockSpeed();
        SidTune.Clock tuneCPUClock = tune != SidTune.RESET ? tune.getInfo().getClockSpeed() : SidTune.Clock.UNKNOWN;
        CPUClock defaultCPUClock = emulation.getDefaultClockSpeed();
        if (forcedCPUClock != AUTO) {
            return forcedCPUClock;
        }
        switch (1.$SwitchMap$libsidplay$sidtune$SidTune$Clock[tuneCPUClock.ordinal()]) {
            case 1: 
            case 2: {
                return tuneCPUClock.asCPUClock();
            }
        }
        return defaultCPUClock;
    }
}

